#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/attr_value.h>

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/string_utils.h>

#include <utility>

namespace maps::wiki::common {

AttrValue::AttrValue(std::string attributeId, std::string value)
    : attributeId_(std::move(attributeId))
    , value_(std::move(value))
{}

bool AttrValue::equals(const AttrValue& other) const { return value() == other; }

bool AttrValue::equals(const char* other) const { return value() == other; }

bool AttrValue::equals(std::string_view other) const { return value() == other; }

bool AttrValue::equals(const std::string& other) const { return value() == other; }

bool AttrValue::operator==(const AttrValue& other) const { return equals(other); }

bool AttrValue::operator!=(const AttrValue& other) const { return !equals(other); }

bool AttrValue::operator!() const { return !as<bool>(); }

template<>
ymapsdf::rd::Direction AttrValue::as() const
{
    return boost::lexical_cast<ymapsdf::rd::Direction>(value_);
}

template<>
bool AttrValue::as() const { return !value_.empty(); }

template<>
std::string AttrValue::as() const { return value_; }

AttrValue::operator bool() const { return as<bool>(); }

AttrsWrap::AttrsWrap(StringMultiMap attributes): attributes_(std::move(attributes)) {}

AttrsWrap::AttrsWrap(const StringMap& attributes)
{
    for (const auto& pair: attributes) {
        for (auto& value: split(pair.second, "|")) {
            attributes_.emplace(pair.first, std::move(value));
        }
    }
}

bool AttrsWrap::empty() const { return attributes_.empty(); }

AttrValue AttrsWrap::operator[](const char* attributeId) const
{
    return (*this)[std::string(attributeId)];
}

AttrValue AttrsWrap::operator[](std::string_view attributeId) const
{
    return (*this)[std::string(attributeId)];
}

AttrValue AttrsWrap::operator[](std::string attributeId) const
{
    const auto it = attributes_.find(attributeId);
    if (it == attributes_.end()) {
        return {std::move(attributeId), ""};
    }
    return {std::move(attributeId), it->second};
}

AttrValues AttrsWrap::range(const char* attributeId) const
{
    return range(std::string(attributeId));
}

AttrValues AttrsWrap::range(std::string_view attributeId) const
{
    return range(std::string(attributeId));
}

AttrValues AttrsWrap::range(const std::string& attributeId) const
{
    const auto pair = attributes_.equal_range(attributeId);

    AttrValues result;
    for (auto it = pair.first; it != pair.second; ++it) {
        result.emplace_back(attributeId, it->second);
    }

    return result;
}

AttrsWrap AttrsWrap::extract(const revision::ObjectRevision& object)
{
    REQUIRE(
        object.data().attributes,
        "Object " << object.id() << " has no attributes"
    );

    return AttrsWrap(*object.data().attributes);
}

} // namespace maps::wiki::common
