#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::common {

ExtendedXmlDoc::ExtendedXmlDoc(const std::string& filename)
{
    parseFile(filename);
}

ExtendedXmlDoc::ExtendedXmlDoc(const std::string& text, SourceType sourceType)
{
    switch (sourceType) {
        case SourceType::XmlFile:
            parseFile(text);
            break;
        case SourceType::XmlString:
            parseText(text);
            break;
    }
}

xml3::Node
ExtendedXmlDoc::node(const std::string& path, bool quiet) const
{
    auto it = docs_.begin();
    auto node = it->node(path, true);
    while (node.isNull() && (++it) != docs_.end()) {
        node = it->node(path, true);
    }
    if (quiet || !node.isNull()) {
        return node;
    }
    return docs_.begin()->node(path, quiet); // throw xml3::NodeNotFound
}

std::string
ExtendedXmlDoc::addDoc(const std::string& filename, xml3::Doc&& doc)
{
    auto node = doc.node("/config/extends", true);
    auto extent = node.isNull()
        ? std::string()
        : node.value<std::string>();

    filenames_.push_back(filename);
    docs_.emplace_back(std::move(doc));

    return extent;
}

void
ExtendedXmlDoc::parseText(const std::string& text)
{
    REQUIRE(!text.empty(), "Non empty xml text expected.");
    docs_.emplace_back(maps::xml3::Doc::fromString(text));
    filenames_.emplace_back(std::string()); // skip filename
}

void
ExtendedXmlDoc::parseFile(const std::string& filename)
{
    bool needReplacePath = filename.find('/') != std::string::npos;

    auto fname = filename;
    while (!fname.empty()) {
        maps::xml3::Doc doc{ fname, xml3::Doc::File };
        fname = addDoc(fname, std::move(doc));
        if (fname.empty()) {
            break;
        }
        if (needReplacePath && fname.find('/') == std::string::npos) {
            fname = filename.substr(0, filename.rfind('/')) + "/" + fname;
        }
    }
    REQUIRE(!docs_.empty(), "Can not find/parse config " << filename);
}

} // namespace maps::wiki::common
