#include <yandex/maps/wiki/common/format_type.h>
#include <iostream>

namespace maps::wiki::common {
namespace
{
const std::string STR_XML = "xml";
const std::string STR_JSON = "json";
} // namespace

std::ostream& operator <<(std::ostream& os, FormatType formatType)
{
    switch(formatType) {
        case FormatType::XML :
            os << STR_XML;
            break;
        case FormatType::JSON :
            os << STR_JSON;
            break;
    }
    return os;
}

std::istream& operator >>(std::istream& is, FormatType& formatType)
{
    std::string word;
    is >> word;
    formatType = word == STR_JSON? FormatType::JSON : FormatType::XML;
    return is;
}

} // namespace maps::wiki::common
