#include <yandex/maps/wiki/common/geojson.h>

#include <maps/libs/json/include/builder.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/serialization.h>
#include <maps/libs/geolib/include/variant.h>

namespace maps::wiki::common {

std::string mercatorWkbToGeoJson(const std::string& wkb)
{
    REQUIRE(!wkb.empty(), "Empty wkb");

    auto mercatorGeometry = geolib3::WKB::read<geolib3::SimpleGeometryVariant>(wkb);
    auto geoGeometry = geolib3::convertMercatorToGeodetic(mercatorGeometry);

    json::Builder b;
    b << geolib3::geojson(geoGeometry);
    return b.str();
}

std::string geoJsonToMercatorWkb(const std::string& geoJson)
{
    REQUIRE(!geoJson.empty(), "Empty geo json");

    auto jsonData = json::Value::fromString(geoJson);
    auto geoGeometry = geolib3::readGeojson<geolib3::SimpleGeometryVariant>(jsonData);
    auto mercatorGeometry = geolib3::convertGeodeticToMercator(geoGeometry);
    return geolib3::WKB::toString(mercatorGeometry);
}

} // namespace maps::wiki::common
