#include <yandex/maps/wiki/common/geom_utils.h>
#include <yandex/maps/wiki/common/string_utils.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/conversion.h>

#include <algorithm>
#include <cmath>
#include <vector>

namespace maps::wiki::common {

std::vector<double> convertToVectorOfDouble(const std::string& str)
{
    std::vector<double> coords;
    for (const auto& coordString : split(str, ",")) {
        coords.push_back(std::stod(coordString));
    }
    return coords;
}

TMercatorPoint
geodeticTomercator(double lon, double lat)
{
    return geolib3::geoPoint2Mercator(geolib3::Point2(lon, lat));
}

TGeoPoint
mercatorToGeodetic(double x, double y)
{
    return mercator2GeoPoint(geolib3::Point2(x, y));
}

geolib3::BoundingBox bboxFromCommaSeparatedCoords(const std::string& str)
{
    auto coords = convertToVectorOfDouble(str);
    REQUIRE(coords.size() == 4,
        "Cannot parse bbox from string. Coordinates num must be equal to 4");

    return {
        geolib3::Point2(coords[0], coords[1]),
        geolib3::Point2(coords[2], coords[3])
    };
}

} // namespace maps::wiki::common
