#include <yandex/maps/wiki/common/icu_helpers.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::common {

std::wstring icuToUtf32(const icu::UnicodeString& ustr)
{
    static_assert(sizeof(UChar32) == sizeof(wchar_t), "sizeof(UChar32) != sizeof(wchar_t)");

    std::wstring result(ustr.length(), 0);

    UErrorCode errorCode = U_ZERO_ERROR;
    int32_t size = ustr.toUTF32(reinterpret_cast<UChar32*>(&result[0]), result.size(), errorCode);
    REQUIRE(U_SUCCESS(errorCode), "Failed to convert UnicodeString to wstring: " << u_errorName(errorCode));

    result.resize(size);
    return result;
}

} // namespace maps::wiki::common
