#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polygon.h>
#include <pqxx/pqxx>
#include <set>

namespace maps::wiki::common {

std::set<uint64_t> calculateAoisContainingPosition(
    const geolib3::Point2& positionMerc,
    pqxx::transaction_base& viewTrunkTxn);

struct AoiParams
{
    uint64_t aoiId{};
    uint64_t commitId{};
    std::string name;
    int type{};
    double area{};
    geolib3::Polygon2 polygonMerc;
};

void addAoiRegionToViewTrunk(
    const AoiParams& aoiParams,
    pqxx::transaction_base& viewTrunkTxn);

} // namespace maps::wiki::common
