#pragma once

#include <yandex/maps/wiki/common/misc.h>

namespace maps::wiki::common {

const std::string COMMIT_PROPVAL_GROUP_MODIFIED_ATTRIBUTES = "group-modified-attributes";
const std::string COMMIT_PROPVAL_GROUP_DELETED = "group-deleted";
const std::string COMMIT_PROPVAL_GROUP_MODIFIED_RELATION = "group-modified-relation";
const std::string COMMIT_PROPVAL_GROUP_MODIFIED_RELATIONS = "group-modified-relations";
const std::string COMMIT_PROPVAL_GROUP_MOVED = "group-moved";
const std::string COMMIT_PROPVAL_GROUP_UNITED = "group-united";
const std::string COMMIT_PROPVAL_GROUP_MERGED = "group-merged";
const std::string COMMIT_PROPVAL_GROUP_SNAPPED = "group-snapped";
const std::string COMMIT_PROPVAL_ACTION_SERVICE = "service";
const std::string COMMIT_PROPVAL_ACTION_IMPORT = "import";
const std::string COMMIT_PROPVAL_OBJECT_CREATED = "object-created";
const std::string COMMIT_PROPVAL_OBJECT_MODIFIED = "object-modified";
const std::string COMMIT_PROPVAL_OBJECT_DELETED = "object-deleted";
const std::string COMMIT_PROPVAL_COMMIT_REVERTED = "commit-reverted";
const std::string COMMIT_PROPKEY_ACTION          = "action";
const std::string COMMIT_PROPKEY_PRIMARY_OBJECT_PREFIX = "primary_object:";
const std::string COMMIT_PROPKEY_EDIT_NOTES_PREFIX = "edit_notes:";
const std::string COMMIT_PROPKEY_ARRAYS_DELIMITER = ",";
const std::string COMMIT_PROPKEY_REVERT_REASON = "revert_reason";
const std::string COMMIT_ATTR_TRUE = "1";

const std::string COMMIT_PROPKEY_GROUP_MOVED_DLON = "group-moved:dlon";
const std::string COMMIT_PROPKEY_GROUP_MOVED_DLAT = "group-moved:dlat";
const std::string COMMIT_PROPKEY_GROUP_MOVED_OBJECTS_COUNT = "group-moved:objects-count";

// Note. Please update tariffs in maps/wikimap/stat/tasks_payment/dictionaries/tariff/data/edits if sets below are changed.
const StringSet COMMIT_NON_GROUP_ACTIONS {
    COMMIT_PROPVAL_ACTION_SERVICE,
    COMMIT_PROPVAL_OBJECT_CREATED,
    COMMIT_PROPVAL_OBJECT_MODIFIED,
    COMMIT_PROPVAL_OBJECT_DELETED,
    COMMIT_PROPVAL_COMMIT_REVERTED
};

const StringSet COMMIT_GROUP_ACTIONS {
    COMMIT_PROPVAL_GROUP_MODIFIED_ATTRIBUTES,
    COMMIT_PROPVAL_GROUP_DELETED,
    COMMIT_PROPVAL_GROUP_MODIFIED_RELATION,
    COMMIT_PROPVAL_GROUP_MODIFIED_RELATIONS,
    COMMIT_PROPVAL_GROUP_MOVED,
    COMMIT_PROPVAL_GROUP_UNITED,
    COMMIT_PROPVAL_GROUP_MERGED,
    COMMIT_PROPVAL_GROUP_SNAPPED,
    COMMIT_PROPVAL_ACTION_IMPORT
};

const StringSet COMMIT_ALL_ACTIONS = mergeSets(COMMIT_NON_GROUP_ACTIONS, COMMIT_GROUP_ACTIONS);

} // maps::wiki::common
