#pragma once

#include <string>
#include <vector>
#include <unordered_map>

namespace maps::wiki::common {

const std::string TOKEN_DB_ALIAS_CORE   = "core";
const std::string TOKEN_DB_ALIAS_SOCIAL = "social";
const std::string TOKEN_DB_ALIAS_TRUNK  = "trunk";
const std::string TOKEN_DB_ALIAS_STABLE = "stable";
const std::string TOKEN_DB_ALIAS_TRUNK_LABELS  = "trunkL";
const std::string TOKEN_DB_ALIAS_STABLE_LABELS = "stableL";

class CompoundToken
{
public:
    CompoundToken() = default;

    void append(const std::string& dbAlias, const std::string& token);

    std::string str() const;

    template <typename TBranchId>
    static std::string alias(TBranchId branchId)
    {
        return branchId
            ? TOKEN_DB_ALIAS_STABLE
            : TOKEN_DB_ALIAS_TRUNK;
    }

    template <typename TBranchId>
    static std::string aliasLabels(TBranchId branchId)
    {
        return branchId
            ? TOKEN_DB_ALIAS_STABLE_LABELS
            : TOKEN_DB_ALIAS_TRUNK_LABELS;
    }

    static std::string subToken(const std::string& compoundToken, const std::string& dbAlias);

    // Check valid formats:
    // <empty>
    // <timestamp1>:<id1>[:core]
    // <timestamp1>:<id1>:core[.<timestampK>:<idK>:<aliasK> ...]
    static bool isValid(const std::string& compoundToken);

private:
    std::vector<std::string> order_;
    std::unordered_map<std::string, std::string> alias2token_;
};

} // namespace maps::wiki::common
