#pragma once

#include <atomic>
#include <exception>
#include <utility>

namespace maps::wiki::common {

class ExceptionTrap {
public:
    ExceptionTrap() = default;

    template<typename Func, typename... Args>
    bool try_(Func func, Args&&... args) noexcept
    {
        if (hasException_) {
            return true;
        }

        try {
            func(std::forward<Args>(args)...);
        } catch (...) {
            if (!hasException_.exchange(true)) {
                exception_ = std::current_exception();
            }
            return true;
        }
        return false;
    }

    bool hasException() const
    { return hasException_; }

    // Not thread-safe
    void release() const
    {
        if (hasException_) {
            std::rethrow_exception(exception_);
        }
    }

private:
    std::atomic<bool> hasException_{false};
    std::exception_ptr exception_;
};

} // namespace maps::wiki::common
