#pragma once

#include <maps/libs/xml/include/xml.h>
#include <string>
#include <memory>

/**
* Provides retrieving of parameters from config file
* @param filename   -    config file
*/

//forward declarations

namespace maps::wiki::common {

/**
 * Extends clause support class
 */
class ExtendedXmlDoc
{
public:
    enum class SourceType
    {
        XmlString,
        XmlFile
    };
    explicit ExtendedXmlDoc(const std::string& filename);
    ExtendedXmlDoc(const std::string& text, SourceType sourceType);

    ExtendedXmlDoc(const ExtendedXmlDoc&) = delete;
    ExtendedXmlDoc& operator=(const ExtendedXmlDoc&) = delete;

    ExtendedXmlDoc(ExtendedXmlDoc&&) = default;
    ExtendedXmlDoc& operator=(ExtendedXmlDoc&&) = default;
    virtual ~ExtendedXmlDoc() = default;


    /**
    * @returns value of element
    */
    template <class ResultType>
    ResultType get(const std::string& path) const{
        return node(path).value<ResultType>();
    }
    /**
    * @returns value of element or defVal
    */
    template <class ResultType>
    ResultType get(const std::string& path, const ResultType& defVal) const{
        xml3::Node n = node(path,true);
        if(!n.isNull()){
            return n.value<ResultType>();
        }
        return defVal;
    }
    /**
    * @returns value of element's attribute by XPath and attrname.
    */
     template <class ResultType>
     ResultType getAttr(const std::string& path, const std::string& name) const{
         xml3::Node n = node(path);
         return n.attr<ResultType>(name);
     }
     /**
     * @returns value of element's attribute by XPath and attrname or defVal.
     */
     template <class ResultType>
     ResultType getAttr(
             const std::string& path,
             const std::string& name,
             const ResultType& defVal) const{

         xml3::Node n = node(path, true);
         if(!n.isNull()){
             return n.attr<ResultType>(name, defVal);
         }
         return defVal;
    }
    /**
    * @returns xml node
    */
    xml3::Node node(const std::string& path, bool quiet=false) const;

    const std::vector<std::string>& sourcePaths() const{
        return filenames_;
    }

protected:
    ExtendedXmlDoc() = default;

    /// @returns value of extend node
    std::string addDoc(const std::string& filename, xml3::Doc&& doc);

private:
    void parseText(const std::string& text);
    void parseFile(const std::string& filename);

    std::vector<xml3::Doc> docs_;
    std::vector<std::string> filenames_;
};

} // namespace maps::wiki::common
