#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/bounding_box.h>

namespace maps::wiki::common {

using TGeoPoint = geolib3::Point2;
using TMercatorPoint = geolib3::Point2;

TGeoPoint mercatorToGeodetic(double x, double y);
TMercatorPoint geodeticTomercator(double lon, double lat);

//
//  String format: lon1,lat1,lon2,lat2
//
geolib3::BoundingBox bboxFromCommaSeparatedCoords(const std::string& str);

//
// String format is comma-separated doubles
//
std::vector<double> convertToVectorOfDouble(const std::string& str);

} // namespace maps::wiki::common
