#pragma once

#include <algorithm>
#include <set>

namespace maps::wiki::common {

template<typename Container, typename Value>
class MinMaxValue
{
public:
    struct Values {
        Value min;
        Value max;
    };

    Values operator ()(const Container& cont) const
    {
        auto minMaxIters = std::minmax_element(cont.begin(), cont.end());
        return {*minMaxIters.first, *minMaxIters.second};
    }
};

template<typename Value>
class MinMaxValue<std::set<Value>, Value>
{
public:
    struct Values {
        Value min;
        Value max;
    };

    Values operator ()(const std::set<Value>& cont) const
    {
        return {*cont.begin(), *cont.rbegin()};
    }
};

} // namespace maps::wiki::common
