#pragma once

#include <boost/optional.hpp>

#include <algorithm>
#include <initializer_list>
#include <set>
#include <string>

namespace maps::wiki::common {

using StringSet = std::set<std::string>;

template<typename T1, typename T2>
bool isIn(const T1& t, std::initializer_list<T2> list)
{
    return std::find(list.begin(), list.end(), t) != list.end();
}

template<typename T1, typename Container>
bool isIn(T1&& t, Container&& list)
{
    return std::find(list.begin(), list.end(), t) != list.end();
}

template<typename T1, typename Container>
boost::optional<typename Container::const_iterator> find(Container&& list, T1&& t)
{
    auto it = std::find(list.begin(), list.end(), t);
    if (it != list.end()) {
        return it;
    }
    return boost::none;
}

template<typename Set>
Set mergeSets(const Set& set1, const Set& set2)
{
    Set result(set1);
    result.insert(set2.cbegin(), set2.cend());
    return result;
}

} // namespace maps::wiki::common
