#pragma once

#include <cstdint>

namespace maps::wiki::common {

enum class AdvisoryLockIds : int64_t
{
    FEEDBACK_SET_DEPLOYED                = 0x1000000000000000, // core
    SYNC_FBAPI_FEEDBACK                  = 0x1000000000000001, // social
    IMPORT_ST_FEEDBACK                   = 0x1000000000000002, // social
    SYNC_ST_FEEDBACK                     = 0x1000000000000003, // social
    SYNC_VIEW                            = 0x1000000000000004, // view
    SCHEDULE_FEEDBACK                    = 0x1000000000000005, // social
    BRANCH_MASK_CLEANER                  = 0x1000000000000006, // core
    YT_SPEED_FEEDBACK                    = 0x1000000000000007, // core
    STAT_OUTSOURCE_REGIONS_DUMP          = 0x1000000000000008, // core
    UPDATE_BADGES                        = 0x1000000000000009, // social
    PUBLICATION_CHECKER                  = 0x100000000000000a, // core
    ONEWAY_HYPS_PRODUCER                 = 0x100000000000000b, // core
    SPRAV_PEDESTRIAN_FEEDBACK            = 0x100000000000000c, // core
    VALIDATION_FEEDBACK_CONVERTER        = 0x100000000000000d, // core
    SKILLS_UPDATER                       = 0x100000000000000e, // social
    ACL_ROLES_DUMPER                     = 0x100000000000000f, // core
    SPRAV_PEDESTRIAN_ENTRANCES           = 0x1000000000000010, // core
    RATING_WORKER                        = 0x1000000000000011, // social
    SPRAV_PEDESTRIAN_ADDRESSES           = 0x1000000000000012, // core
    ROUTE_LOSTS_PRODUCER                 = 0x1000000000000013, // social
    PREAPPROVED_QUEUE_WORKER             = 0x1000000000000014, // core
    USER_EDITS_METRICS                   = 0x1000000000000015, // view
    SPRAV_TASK_NOT_SUBMITTED             = 0x1000000000000016, // social
    SPRAV_TASK_NEW                       = 0x1000000000000017, // social
    SPRAV_TASK_IN_PROGRESS               = 0x1000000000000018, // social
    SPRAV_TASK_ACCEPTED                  = 0x1000000000000019, // social
    STAT_USERS_DUMP                      = 0x100000000000001a, // core
    STAT_UPLOAD_MODDASHBOARD             = 0x100000000000001b, // social
    EXPORT_CLEANER                       = 0x100000000000001c, // core
    EXPORT_POI                           = 0x100000000000001d, // social
    MERGE_POI                            = 0x100000000000001e, // social
    NOTIFICATIONS_DISPATCHER             = 0x100000000000001f, // social
    RELEASE_METRICS                      = 0x1000000000000020, // dataprod stat
    AUTO_MAILER                          = 0x1000000000000021, // social
    PERMISSIONS_SYNCHRONIZER             = 0x1000000000000022, // core
    ACL_CLUSTERS                         = 0x1000000000000023, // core
    ASSESSMENT_SAMPLER                   = 0x1000000000000024, // social
    // ASSESSMENT_SAMPLER_BASIC_FEEDBACK    = 0x1000000000000025, // social
    // ASSESSMENT_SAMPLER_BASIC_MODERATION  = 0x1000000000000026, // social
    // ASSESSMENT_SAMPLER_EXPERT_EDITS      = 0x1000000000000027, // social
    // ASSESSMENT_SAMPLER_EXPERT_FEEDBACK   = 0x1000000000000028, // social
    // ASSESSMENT_SAMPLER_EXPERT_MODERATION = 0x1000000000000029, // social
    INDOOR_FEEDBACK                      = 0x100000000000002a, // core
    SOCIAL_CLEANER                       = 0x100000000000002b, // social
    WALKERS_EXPORT_DOWNLOADER            = 0x100000000000002c, // social
    GDPR                                 = 0x100000000000002d, // core
    YANG_DOWNLOADER                      = 0x100000000000002e, // social
    TOLOKA_ENTRANCE_DOWNLOADER           = 0x100000000000002f, // social
    EXPORT_WORKER                        = 0x1000000000000030, // export
    MATVIEW_REFRESHER                    = 0x1000000000000031, // social
};

} // namespace maps::wiki::common
