#pragma once

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/pgpool3utils/dynamic_pool_holder.h>

namespace maps::wiki::common {

class PoolHolder : public pgp3utils::DynamicPoolHolder
{
public:
    PoolHolder(
        OverrideConstants overrideConstants,
        const xml3::Node& dbNode,
        const std::string& dbId,
        const std::string& poolId,
        const std::string& logRecordPrefix = std::string());

    // empty prefix string = "pgpool.$dbId"
    PoolHolder(
        OverrideConstants overrideConstants,
        const ExtendedXmlDoc& cfg,
        const std::string& dbId,
        const std::string& poolId,
        const std::string& logRecordPrefix = std::string());

    // empty prefix string = "pgpool.$dbId"
    PoolHolder(
        const ExtendedXmlDoc& cfg,
        const std::string& dbId,
        const std::string& poolId,
        const std::string& logRecordPrefix = std::string());

    // empty prefix string = "pgpool.$dbId"
    PoolHolder(
        const xml3::Node& dbNode,
        const std::string& dbId,
        const std::string& poolId,
        const std::string& logRecordPrefix = std::string());
};

} // namespace maps::wiki::common
