#pragma once

#include <boost/optional.hpp>
#include <boost/python.hpp>
#include <boost/python/stl_iterator.hpp>

#include <optional>
#include <vector>

namespace maps::wiki::common {

template<typename T>
std::vector<T> toVector(const boost::python::object& obj)
{
    boost::python::stl_input_iterator<T> begin(obj);
    static const boost::python::stl_input_iterator<T> end;

    return std::vector<T>(begin, end);
}

template<class Container>
boost::python::list toPyList(const Container& container)
{
    boost::python::list result;
    for (const auto& item : container) {
        result.append(item);
    }
    return result;
}

template<typename T>
boost::optional<T> toOptional(const boost::python::object& obj)
{
    if (obj.ptr() == Py_None) { // no 'is' comparison in Boost.Python
        return {};
    }
    return boost::python::extract<T>(obj)();
}

template<typename T>
boost::python::object toPyObject(const boost::optional<T>& optional)
{
    if (optional) {
        return boost::python::object(*optional);
    }
    return {};
}

template<typename T>
boost::python::object toPyObject(const std::optional<T>& optional)
{
    if (optional) {
        return boost::python::object(*optional);
    }
    return {};
}

} // namespace maps::wiki::common
