#pragma once

#include <yandex/maps/wiki/common/lrucache.h>
#include <chrono>
#include <memory>
#include <vector>

namespace maps::wiki::common {

template <typename Key>
class RateCounter
{
public:
    RateCounter(size_t cacheSize, std::chrono::milliseconds cacheTime)
        : lruCache_(cacheSize, cacheTime)
    {}

    size_t add(const Key& key)
    {
        auto now = Clock::now();

        auto optValue = lruCache_.get(key);
        if (!optValue) {
            Value value = std::make_shared<TimePoints>();
            value->emplace_back(now);
            lruCache_.put(key, std::move(value));
            return 1;
        }

        auto expired = now - lruCache_.cacheTime();
        Value& value = *optValue;
        value->erase(
            std::remove_if(
                value->begin(),
                value->end(),
                [&](const auto& tp) { return tp < expired; }
            ),
            value->end()
        );
        value->emplace_back(now);
        auto newCount = value->size();
        lruCache_.put(key, std::move(value));
        return newCount;
    }

private:
    using Clock = std::chrono::system_clock;
    using TimePoint = std::chrono::time_point<Clock, std::chrono::nanoseconds>;
    using TimePoints = std::vector<TimePoint>;
    using Value = std::shared_ptr<TimePoints>; // TODO: intrusive_ptr

    LRUCache<Key, Value> lruCache_;
};


} // namespace maps::wiki::common
