#pragma once

namespace maps::wiki::common {

enum class AccessId : int {
    None = 0,
    Pedestrian = (1 << 0),
    Bus = (1 << 1),
    Truck = (1 << 2),
    Car = (1 << 3),
    Bicycle = (1 << 4),
    Taxi = (1 << 5),
    Scooter = (1 << 6),
    Moto = (1 << 7),
};

constexpr AccessId operator&(AccessId lhs, AccessId rhs)
{
    return static_cast<AccessId>(static_cast<int>(lhs) & static_cast<int>(rhs));
}

constexpr AccessId operator|(AccessId lhs, AccessId rhs)
{
    return static_cast<AccessId>(static_cast<int>(lhs) | static_cast<int>(rhs));
}

constexpr bool operator!(AccessId accessId)
{
    return accessId == AccessId::None;
}

constexpr bool isSet(AccessId toCheck, AccessId flags)
{
    return (toCheck & flags) == toCheck;
}

inline bool isValid(AccessId accessId)
{
    auto value = static_cast<int>(accessId);
    return value >= 0 && value < (1 << 8);
}

} // namespace maps::wiki::common
