#pragma once

#include <yandex/maps/wiki/common/misc.h>

namespace maps::wiki::common {

enum class ConditionType {
    Prohibited = 1,
    Uturn = 3,
    Barrier = 5,

    CameraSpeed = 15,
    CameraMtr = 16,
    CameraPolice = 17,
    CameraMarking = 21,
    CameraCross = 22,
    CameraStop = 23,
    Preffered = 24,
    UnhinderedBorderCross = 25,
};

inline bool isValid(ConditionType condType)
{
    return common::isIn(condType, {
        ConditionType::Prohibited,
        ConditionType::Uturn,
        ConditionType::Barrier,
        ConditionType::CameraSpeed,
        ConditionType::CameraMtr,
        ConditionType::CameraPolice,
        ConditionType::CameraMarking,
        ConditionType::CameraCross,
        ConditionType::CameraStop,
        ConditionType::Preffered,
        ConditionType::UnhinderedBorderCross,
    });
}

} // namespace maps::wiki::common
