#pragma once

namespace maps::wiki::common {

enum class Direction {
    Forward = (1 << 0),
    Backward = (1 << 1),
    Both = Forward | Backward
};

constexpr Direction operator&(Direction lhs, Direction rhs)
{
    return static_cast<Direction>(static_cast<int>(lhs) & static_cast<int>(rhs));
}

constexpr Direction operator|(Direction lhs, Direction rhs)
{
    return static_cast<Direction>(static_cast<int>(lhs) | static_cast<int>(rhs));
}

constexpr bool isSet(Direction toCheck, Direction flags)
{
    return (toCheck & flags) == toCheck;
}

} // namespace maps::wiki::common
