#pragma once

#include <yandex/maps/wiki/common/misc.h>

namespace maps::wiki::common {

enum class FOW {
    None = 0,
    TwoCarriageway = 2,
    Roundabout = 4,
    Ramp = 10,
    AlternateRoad = 11,
    Driveway = 13,
    Turnabout = 17,
    PedestrianCrossing = 18
};

inline bool isValid(FOW fow)
{
    return common::isIn(fow, {
        FOW::None,
        FOW::TwoCarriageway,
        FOW::Roundabout,
        FOW::Ramp,
        FOW::AlternateRoad,
        FOW::Driveway,
        FOW::Turnabout,
        FOW::PedestrianCrossing});
}

} // namespace maps::wiki::common
