#pragma once

#include <maps/libs/common/include/exception.h>

#include <memory>
#include <string>
#include <vector>

namespace maps::wiki::common {

const std::string STR_RD_EL_LANE = "rd_el_lane";
const std::string STR_RD_EL_ID = "rd_el_id";
const std::string STR_F_LANE = "f_lane";
const std::string STR_T_LANE = "t_lane";
const std::string STR_F_RD_EL_DIR = "F";
const std::string STR_T_RD_EL_DIR = "T";
const std::string STR_RD_EL_DIRECTION = "rd_el_direction";
const std::string STR_LANE_NUM = "lane_num";
const std::string STR_LANE_KIND = "lane_kind";
const std::string STR_LANE_DIRECTION_ID = "lane_direction_id";
const std::string STR_LANE_DELIM = ";";
const std::string STR_LANE_KIND_DELIM = ":";
const std::string STR_LANE_DIRECTIONS_DELIM = ",";

struct LaneAttrDir {
    std::string laneAttr;
    std::string dir;
};

const std::vector<LaneAttrDir> PASSES {
    {STR_F_LANE, STR_F_RD_EL_DIR},
    {STR_T_LANE, STR_T_RD_EL_DIR}
};

struct LaneDirCode
{
    std::string laneDir;
    unsigned int bitMask;
};

enum class LaneDirection {
    Left180 = 1 << 0,
    Left135 = 1 << 1,
    Left90 = 1 << 2,
    Left45 = 1 << 3,
    StraightAhead = 1 << 4,
    Right45 = 1 << 5,
    Right90 =  1 << 6,
    Right135 = 1 << 7,
    Right180 = 1 << 8,
    LeftFromRight = 1 << 9,
    RightFromLeft = 1 << 10,
    LeftShift = 1 << 11,
    RightShift = 1 << 12,
    None = 0,
    Max = RightShift
};

enum class LaneKind {
    Auto = 0,
    Bus = 1,
    Tram = 2,
    Bike = 3,
};

enum class LaneOrientation {
    F,
    T
};

class LanesException : public maps::Exception
{
};

class Lane
{
public:
    explicit Lane(const std::string&);
    Lane(size_t directionsId, LaneKind kind);

    bool contains(const LaneDirection& direction) const;
    std::string toString() const;
    size_t directionsId() const;
    const std::vector<LaneDirection>& directions() const;
    LaneKind kind() const;

private:
    std::vector<LaneDirection> directions_;
    LaneKind kind_;
};

using Lanes = std::vector<Lane>;

std::string toString(const LaneDirection& direction);
LaneDirection laneDirectionFromString(const std::string& directionStr);
std::string toString(const LaneKind& kind);
LaneKind laneKindFromString(const std::string& kindString);
Lanes lanesFromString(const std::string& laneAttrValue);
std::string toString(const std::vector<Lane>& lanes);
std::vector<LaneDirection> directionsFromId(size_t directionsId);

} // namespace maps::wiki::common
