#pragma once

#include <yandex/maps/wiki/common/misc.h>

namespace maps::wiki::common {

enum class StructType {
    None = 0,
    Bridge = 1,
    Tunnel = 2,
    FerryCrossing = 3,
    Ford = 4,
    Stairs = 5
};

inline bool isValid(StructType structType)
{
    return common::isIn(structType, {
        StructType::None,
        StructType::Bridge,
        StructType::Tunnel,
        StructType::FerryCrossing,
        StructType::Ford,
        StructType::Stairs});
}

} // namespace maps::wiki::common
