#pragma once

#include <maps/wikimap/mapspro/libs/types/include/uid.h>
#include <yandex/maps/wiki/common/misc.h>

#include <vector>

namespace maps::wiki::common {

constexpr types::TUid ROBOT_UID = 82282794;
constexpr types::TUid WIKIMAPS_BLD_UID = 684818229;
constexpr types::TUid WIKIMAPS_SPRAV_UID = 685892448;
constexpr types::TUid WIKIMAPS_SPRAV_COMMON_UID = 849045663;

const std::vector ALL_ROBOTS_UIDS = {
    ROBOT_UID,
    WIKIMAPS_BLD_UID,
    WIKIMAPS_SPRAV_UID,
    WIKIMAPS_SPRAV_COMMON_UID
};

inline bool isRobot(types::TUid uid)
{
    return isIn(uid, ALL_ROBOTS_UIDS);
}

} // namespace maps::wiki::common
