#pragma once

#include <maps/libs/common/include/pimpl_utils.h>

#include <string>
#include <fstream>
#include <vector>

namespace maps::wiki::common {

class TskvMessage
{
public:
    // Creates a message without `tskv tskv_format=...` prefix.
    TskvMessage();

    // Creates a message with prefix `tskv tskv_format=...`
    //
    // @deprecated The prefix is not necessary anymore, therefore it is
    // recommended to use the constructor without arguments. However, old logs
    // must not be switched if they shipped to statbox. This fact can be checked
    // here: https://yt.yandex-team.ru/<cluster-name>/navigation?path=//statbox
    explicit TskvMessage(std::string tskvFormat);

    template<typename T>
    void setParam(std::string key, T value)
    {
        setParam(std::move(key), std::to_string(value));
    }

    void setParam(std::string key, std::string value);

    std::string toString() const;

    COPYABLE_PIMPL_DECLARATIONS(TskvMessage)
};

using TskvMessages = std::vector<TskvMessage>;

class ITskvLogger
{
public:
    virtual void log(TskvMessage logMessage) = 0;
    void log(const TskvMessages& logMessages);
    virtual void onLogrotate() = 0;
    virtual ~ITskvLogger() = default;
};

class TskvLogger : public ITskvLogger
{
public:
    explicit TskvLogger(std::string logPath);

    void log(TskvMessage logMessage) override;
    void onLogrotate() override;

    NONCOPYABLE_PIMPL_DECLARATIONS(TskvLogger)
};

} // namespace maps::wiki::common
