#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/passport_to_staff.h>

#include <unordered_map>

namespace maps::wiki::common {

namespace {

const std::unordered_map<std::string, std::string> NMAPS_TO_STAFF = {
    { "yndx-adeshov", "adeshov" },
    { "yndx-igorobets", "igorobets" },
    { "yndx-asd", "igor-yandex" },
    { "yndx-afedorov", "afedorov" },
    { "yndx-dstrelkov", "dstrelkov" },
    { "yndx-eastapov", "eastapov" },
    { "yndx-amaksimov", "amaksimov" },
    { "yndx-alina90", "alina90" },
    { "yndx-lumilia", "lumilia" },
    { "yndx-tbredina", "tbredina" },
    { "yndx-evmatveev", "evmatveev" },
    { "yndx-laptev-sea", "laptev-sea" },
    { "yndx-helenga", "helenga" },
    { "vyborgia", "vyborgia" },
    { "yndx-karanikin", "karanikin" },
    { "timfro", "timfr0" },
    { "coloneljuanfernandez", "s-prok96" },
    { "yndx-alexbobkov", "alexbobkov" },
    { "annakichatova", "confeta" },
};

} // namespace

std::string getStaffLoginByPassportLogin(const std::string& nmapsLogin)
{
    auto staffLoginIt = NMAPS_TO_STAFF.find(nmapsLogin);
    if (staffLoginIt != NMAPS_TO_STAFF.end()) {
        return staffLoginIt->second;
    }
    return {};
}

} // namespace maps::wiki::common
