#include <yandex/maps/wiki/common/pg_utils.h>

#include <boost/algorithm/string/split.hpp>

namespace maps::wiki::common {

Hstore attributesToHstore(
    const pqxx::transaction_base& txn,
    const Attributes& attrs)
{
    std::string result;
    for (const auto& attr : attrs) {
        if (!attr.first.empty() && !attr.second.empty()) {
            if (!result.empty()) {
                result.push_back(',');
            }
            result += (
                "['" + txn.esc(attr.first) +
                "','" + txn.esc(attr.second) + "']");
        }
    }
    if (result.empty()) {
        return {};
    }
    return "hstore(ARRAY[" + result + "])";
}

std::vector<std::string> parseSqlArray(const std::string& data)
{
    REQUIRE(
        (data.front() == '{') && (data.back() == '}'),
        "Wrong array representation received"
    );

    auto isComma = [](char c) {
        return (c == ',');
    };

    std::vector<std::string> result;
    auto dataWithoutParanthesis = data.substr(1, data.size() - 2);
    if (!dataWithoutParanthesis.empty()) {
        //boost::split behaviour is strange when input string is empty
        boost::split(result, dataWithoutParanthesis, isComma);
    }
    return result;
}

} // namespace maps::wiki::common
