#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <utility>

namespace maps::wiki::common {

namespace {

std::string makeLogName(
    const std::string& dbId,
    const std::string& logRecordPrefix)
{
    if (logRecordPrefix.empty()) {
        return "pgpool." + dbId;
    }
    return logRecordPrefix;
}

} // namespace

PoolHolder::PoolHolder(
    OverrideConstants overrideConstants,
    const xml3::Node& dbNode,
    const std::string& dbId,
    const std::string& poolId,
    const std::string& logRecordPrefix)
    : pgp3utils::DynamicPoolHolder(
        dbNode,
        poolId,
        makeLogName(dbId, logRecordPrefix),
        std::move(overrideConstants))
{
}

PoolHolder::PoolHolder(
    OverrideConstants overrideConstants,
    const ExtendedXmlDoc& cfg,
    const std::string& dbId,
    const std::string& poolId,
    const std::string& logRecordPrefix)
    : pgp3utils::DynamicPoolHolder(
        cfg.node("/config/common/databases/database[@id=\"" + dbId + "\"]"),
        poolId,
        makeLogName(dbId, logRecordPrefix),
        std::move(overrideConstants))
{
}

PoolHolder::PoolHolder(
    const ExtendedXmlDoc& cfg,
    const std::string& dbId,
    const std::string& poolId,
    const std::string& logRecordPrefix)
    : pgp3utils::DynamicPoolHolder(
        cfg.node("/config/common/databases/database[@id=\"" + dbId + "\"]"),
        poolId,
        makeLogName(dbId, logRecordPrefix))
{
}

PoolHolder::PoolHolder(
    const xml3::Node& dbNode,
    const std::string& dbId,
    const std::string& poolId,
    const std::string& logRecordPrefix)
    : pgp3utils::DynamicPoolHolder(
        dbNode,
        poolId,
        makeLogName(dbId, logRecordPrefix))
{
}

} // namespace maps::wiki::common
