#include <yandex/maps/wiki/common/rd/speed_cat.h>
#include <yandex/maps/wiki/common/misc.h>
#include <maps/libs/common/include/exception.h>

#include <map>

namespace maps::wiki::common {

namespace {

const std::map<int, SpeedInterval> SPEED_CAT_TO_SPEED_INTERVAL {
    {1, {130, 150}},
    {2, {101, 130}}, {21, {126, 130}}, {22, {121, 125}}, {23, {116, 120}}, {24, {111, 115}}, {25, {106, 110}}, {26, {101, 105}},
    {3, {91, 100}}, {31, {96, 100}}, {32, {91, 95}},
    {4, {71, 90}}, {41, {86, 90}}, {42, {81, 85}}, {43, {76, 80}}, {44, {71, 75}},
    {5, {51, 70}}, {51, {66, 70}}, {52, {61, 65}}, {53, {56, 60}}, {54, {51, 55}},
    {6, {31, 50}}, {61, {46, 50}}, {62, {41, 45}}, {63, {36, 40}}, {64, {31, 35}},
    {7, {11, 30}}, {71, {26, 30}}, {72, {21, 25}}, {73, {16, 20}}, {74, {11, 15}},
    {8, {0, 10}}, {81, {6, 10}}, {82, {0, 5}},
};

} // namespace

SpeedInterval toSpeedInterval(int speedCat)
{
    const auto it = SPEED_CAT_TO_SPEED_INTERVAL.find(speedCat);
    REQUIRE(
        it != SPEED_CAT_TO_SPEED_INTERVAL.end(),
        "Wrong speed category"
    );

    return it->second;
}

int predictSpeedCategory(int fc, FOW fow, bool paved)
{
    if (fow == FOW::Turnabout) {
        return 81;
    }

    if (fc == 1) {
        if (isIn(fow, {FOW::None, FOW::TwoCarriageway, FOW::AlternateRoad})) {
            return 31;
        }

        if (isIn(fow, {FOW::Roundabout, FOW::Ramp})) {
            return 63;
        }
    }

    if (fc == 2) {
        return isIn(fow, {FOW::None, FOW::TwoCarriageway, FOW::AlternateRoad}) ? 51 : 63;
    }

    if (fc == 3 || fc == 4) {
        return 63;
    }

    if (fc == 5) {
        return 64;
    }

    if (fc == 6) {
        return 71;
    }

    if (fc == 7) {
        return paved ? 73 : 74;
    }

    if (fc == 8 || fc == 9) {
        return 74;
    }

    if (fc == 10) {
        return 82;
    }

    return 0;
}

} // namespace maps::wiki::common
