#include <yandex/maps/wiki/common/secrets.h>

#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/libs/enum_io/include/enum_io.h>

#include <string>

namespace maps::wiki::common::secrets {

namespace {

// comes from here https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/cfg/secrets/yav-deploy/defaults.conf
const std::string TOKENS_PATH = "/etc/yandex/maps/wiki/secrets/tokens/";

const enum_io::Representations<Key> KEY_REPRESENTATIONS{
    {Key::RobotWikimapSqsToken, "robot-wikimap-sqs-token"},
    {Key::RobotWikimapStaffToken, "robot-wikimap-staff-token"},
    {Key::RobotWikimapStatToken, "robot-wikimap-stat-token"},
    {Key::RobotWikimapStToken, "robot-wikimap-st-token"},
    {Key::RobotWikimapSupToken, "robot-wikimap-sup-token"},
    {Key::RobotWikimapTankerToken, "robot-wikimap-tanker-token"},
    {Key::RobotWikimapYangToken, "robot-wikimap-yang-token"},
    {Key::RobotWikimapYtToken, "robot-wikimap-yt-token"},
};

} // namespace

DEFINE_ENUM_IO(Key, KEY_REPRESENTATIONS);


std::string tokenByKey(Key key)
{
    return vault_boy::DirectoryContext(TOKENS_PATH).getValue(std::string(toString(key)));
}

} // namespace maps::wiki::common::secrets
