#include <yandex/maps/wiki/common/yt.h>

#include <yandex/maps/wiki/common/secrets.h>

#include <util/string/strip.h>
#include <util/system/env.h>

namespace maps::wiki::common::yt {

namespace {

const TString YT_TOKEN_ENV = "YT_TOKEN";
const TString YT_SECURE_VAULT_PREFIX = "YT_SECURE_VAULT_";

} // namespace

NYT::IClientPtr createYtClient(const TString& ytProxy)
{
    auto ytToken = Strip(GetEnv(YT_TOKEN_ENV));
    if (ytToken.empty()) {
        ytToken = common::secrets::tokenByKey(
            common::secrets::Key::RobotWikimapYtToken);
    }
    return NYT::CreateClient(
        ytProxy,
        NYT::TCreateClientOptions().Token(ytToken)
    );
}

TString getSecureVaultValue(const TString& key)
{
    return Strip(GetEnv(YT_SECURE_VAULT_PREFIX + key));
}

} // namespace maps::wiki::common::yt
