#include <yandex/maps/wiki/configs/editor/category_template.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class CategoryTemplate::Impl
{
public:
    explicit Impl(const maps::xml3::Node& node)
        : id(node.attr<std::string>("id"))
    {
        auto sectionRefs = node.nodes("attributes-sections/section", /* quiet= */ true);
        for (size_t i = 0; i < sectionRefs.size(); ++i) {
            sections.push_back(sectionRefs[i].attr<std::string>("id"));
        }

        auto systemAttrNodes =  node.nodes("system-attributes/attribute", true);
        for (size_t i = 0; i < systemAttrNodes.size(); ++i) {
            systemAttributes.insert(systemAttrNodes[i].attr<std::string>("id"));
        }

        auto geometryNode = node.node("geometry", /* quiet= */ true);
        if (!geometryNode.isNull()) {
            geometryType = geometryNode.attr<std::string>("type");
            interactivityId = geometryNode.attr<std::string>("interactivity-id");
        }
    }

    std::string id;
    StringVec sections;
    StringSet systemAttributes;
    std::string geometryType;
    std::string interactivityId;
};

MOVABLE_PIMPL_DEFINITIONS(CategoryTemplate)

CategoryTemplate::CategoryTemplate(const maps::xml3::Node& node)
    : impl_(new Impl{node})
{}

const std::string& CategoryTemplate::id() const { return impl_->id; }
const StringVec& CategoryTemplate::sections() const { return impl_->sections; }
const StringSet& CategoryTemplate::systemAttributes() const { return impl_->systemAttributes; }

bool CategoryTemplate::hasGeometryType() const { return !impl_->geometryType.empty(); }
const std::string& CategoryTemplate::geometryType() const { return impl_->geometryType; }

bool CategoryTemplate::isGeometryTypeValid(const std::string& geometryType) const
{
    return !geometryType.empty() && impl_->geometryType == geometryType;
}

const std::string& CategoryTemplate::interactivityId() const
{
    REQUIRE(!impl_->interactivityId.empty(), "No interactivity found in category template: " << impl_->id);
    return impl_->interactivityId;
}

} // editor
} // configs
} // wiki
} // maps
