#include <yandex/maps/wiki/configs/editor/geoobject_templates.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

GeoObjectTemplate::GeoObjectTemplate(const maps::xml3::Node& node)
    : id_(node.attr<std::string>("id"))
    , category_(node.firstElementChild("category").attr<std::string>("id"))
{
    auto attrNodes = node.nodes("attrs/attr", true);
    for (size_t i = 0; i < attrNodes.size(); ++i) {
        const auto& node = attrNodes[i];
        attrValues_.emplace(
            node.attr<std::string>("id"),
            node.value<std::string>());
    }
}

GeoObjectTemplates::GeoObjectTemplates(const maps::xml3::Node& node)
{
    auto templateNode = node.firstElementChild("geoobject-template");
    while (!templateNode.isNull()) {
        GeoObjectTemplate template_(templateNode);
        templatesByCategory_[template_.category()].push_back(std::move(template_));
        templateNode = templateNode.nextElementSibling("geoobject-template");
    }
}

const TemplateVector&
GeoObjectTemplates::findTemplates(const std::string& categoryId) const
{
    auto iter = templatesByCategory_.find(categoryId);
    static TemplateVector emptyTemplateVector;
    return iter == templatesByCategory_.end()
        ? emptyTemplateVector
        : iter->second;
}

} // namespace editor
} // namespace configs
} // namespace wiki
} // namespace maps
