#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <optional>
#include <list>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

const std::string TRUE_VALUE = "1";
const std::string FALSE_VALUE = "";

enum class ValueType
{
    Boolean,
    Integer,
    Float,
    Bitmask,
    String,
    Enum,
    Table,
    Json,
    Login
};

/**
 * Represents wikimap object attribute value
 */
struct Value
{
    Value(std::string value, std::string label)
        : value(std::move(value))
        , label(std::move(label))
    {}

    bool operator==(const std::string& to) const
    {
        return value == to;
    }

    std::string value;
    std::string label;
};

typedef std::list<Value> ValueList;
typedef std::vector<std::string> StringVector;

/**
 * Represents wikimap object attribute
 */
class AttributeDef
{
public:
    struct Directional
    {
        explicit Directional(const maps::xml3::Node& valuesNode);

        std::string fromValue;
        std::string toValue;
        std::string bothValue;
    };
    
    static const char MULTIVALUE_DELIMITER;

    AttributeDef(std::string id, std::string defaultValue, const StringSet& allowedValues);
    explicit AttributeDef(const maps::xml3::Node& node);

    const std::string& id() const;

    const std::string& idA() const;
    const std::string& idB() const;
    bool isA() const;
    bool isB() const;

    const std::string& label() const;
    ValueType valueType() const;
    bool anyValue() const;
    bool booleanValue() const;
    bool objectAccessControl() const;

    bool mergeable() const;
    bool copyable() const;

    bool multiValue() const;
    size_t minValues() const;
    size_t maxValues() const;
    static StringVector unpackMultiValue(const std::string& value);

    bool junctionSpecific() const;
    const std::string& junctionSpecificPolicy() const;
    const std::string& junctionSpecificPolicyAttribute() const;

    bool system() const;
    const std::string& tips() const;
    const ValueList& values() const;
    size_t minLen() const;
    size_t maxLen() const;

    bool table() const;
    bool uniqueRows() const;
    const std::string& rowObjCategory() const;
    const std::string& rowObjRole() const;

    const std::string& roleAttr() const;

    const std::string& defaultValue() const;
    std::string allowedValue(const std::string& value) const;
    const std::string& autoValue() const;

    ///Table attribute column attributes
    const StringSet& columns() const;
    const StringSet& keyColumns() const;

    const std::optional<Directional>& directional() const;

    const std::string& requiredAttributeId() const;
    bool required() const;

    MOVABLE_PIMPL_DECLARATIONS(AttributeDef)
};

} // editor
} // configs
} // wiki
} // maps
