#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>
#include <yandex/maps/wiki/configs/editor/fwd.h>
#include <yandex/maps/wiki/configs/editor/unique_list.h>
#include <yandex/maps/wiki/configs/editor/role_filters.h>

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <optional>
#include <list>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

typedef UniqueList<SlaveRole, std::string> SlaveRoles;
typedef std::list<MasterRole> MasterRoles;

class Category
{
public:
    explicit Category(const maps::xml3::Node& node);

    const std::string& id() const;
    const std::string& label() const;

    const AttrDefsVector& attrDefs() const;
    const AttrDefPtr& attribute(const std::string& id) const;
    bool isAttributeDefined(const std::string& id) const;

    const Restrictions& restrictions() const;
    const CategoryTemplate& categoryTemplate() const;

    const std::string& templateId() const;
    const std::string& generalizationId() const;

    bool complex() const;
    bool system() const;
    bool isPrivate() const;
    bool suggest() const;
    bool syncView() const;
    bool autoApprove() const;
    bool hasNames() const;

    bool slavesTopologicalyContinuous() const;
    bool masterRequired() const;
    std::optional<size_t> cacheGeomPartsThreshold() const;

    const SlaveRoles& slavesRoles() const;
    const SlaveRole& slaveRole(const std::string& roleId) const;
    bool isSlaveRoleDefined(const std::string& roleId) const;

    const MasterRoles& masterRoles() const;
    MasterRoles masterRole(const std::string& roleId) const;

    std::string aclPermissionName() const;

    StringSet roleIds(RelationType relationType, roles::filters::Filter filter) const;
    StringSet slaveRoleIds(roles::filters::Filter filter) const;
    StringSet masterRoleIds(roles::filters::Filter filter) const;

    //! Ordered geom slave roles
    StringVec geomSlaveRoleIds() const;

    StringSet relativeCategoryIds(
        RelationType relationType, roles::filters::Filter filter) const;
    StringSet slaveCategoryIds(roles::filters::Filter filter) const;
    StringSet masterCategoryIds(roles::filters::Filter filter) const;

    const std::string& richContentType() const;
    const std::string& richContentFileExt() const;

    const std::string& kind() const;

    bool showSlavesDiff() const;

    friend class Categories;

    MOVABLE_PIMPL_DECLARATIONS(Category)
};

class Categories
{
public:
    typedef std::function<bool(const Category&)> Filter;
    typedef std::map<std::string, Category> CategoriesMap;

    static const Filter All;
    static const Filter CachedGeom;
    static const Filter Suggest;

    explicit Categories(const maps::xml3::Node& categoriesNode);

    const Category& operator[](const std::string& categoryId) const;

    bool defined(const std::string& categoryId) const;

    StringSet idsByFilter(const Filter& filter) const;

    CategoriesMap::const_iterator begin() const;
    CategoriesMap::const_iterator end() const;

    void onLoad(ConfigHolder& config);

    MOVABLE_PIMPL_DECLARATIONS(Categories)
};

} // editor
} // configs
} // wiki
} // maps
