#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class CategoryGroup
{
public:
    explicit CategoryGroup(const maps::xml3::Node& node);

    const std::string& id() const;
    const std::string& label() const;
    const StringSet& categoryIds() const;

    MOVABLE_PIMPL_DECLARATIONS(CategoryGroup)
};

class CategoryGroups
{
public:
    explicit CategoryGroups(const maps::xml3::Node& node);

    const StringSet& categoryIdsByGroup(const std::string& groupId) const;
    StringSet categoryIdsByGroups(const StringSet& groupIds) const;

    GroupPtr findGroupByCategoryId(const std::string& categoryId) const;

    bool isGroupExists(const std::string& groupId) const;
    const GroupPtr& groupById(const std::string& groupId) const;

    const GroupByIdMap& allGroups() const;

    MOVABLE_PIMPL_DECLARATIONS(CategoryGroups)
};

} // editor
} // configs
} // wiki
} // maps
