#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class CategoryTemplate
{
public:
    explicit CategoryTemplate(const maps::xml3::Node& node);

    const std::string& id() const;
    const StringVec& sections() const;
    const StringSet& systemAttributes() const;

    bool hasGeometryType() const;
    const std::string& geometryType() const;
    bool isGeometryTypeValid(const std::string& geometryType) const;

    const std::string& interactivityId() const;

    MOVABLE_PIMPL_DECLARATIONS(CategoryTemplate)
};

} // editor
} // configs
} // wiki
} // maps
