#pragma once

#include <set>
#include <map>
#include <unordered_map>
#include <vector>
#include <string>
#include <memory>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

typedef std::vector<std::string> StringVec;
typedef std::set<std::string> StringSet;
typedef std::map<std::string, std::string> StringMap;

class AttributeDef;
typedef std::shared_ptr<AttributeDef> AttrDefPtr;
typedef std::vector<AttrDefPtr> AttrDefsVector;

class CategoryGroup;
typedef std::shared_ptr<CategoryGroup> GroupPtr;
typedef std::map<std::string, GroupPtr> GroupByIdMap;

class OverlayGroup;
typedef std::shared_ptr<OverlayGroup> OverlayGroupPtr;
typedef std::unordered_map<std::string, OverlayGroupPtr> OverlayGroupByIdMap;

enum class RelationType { Master, Slave };

} // editor
} // configs
} // wiki
} // maps
