#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>
#include <yandex/maps/wiki/configs/editor/fwd.h>

#include <maps/libs/xml/include/xml.h>

#include <map>
#include <memory>

namespace maps::wiki::configs::editor {

class ConfigHolder
{
public:
    ConfigHolder(); // load data from resource (without rubrics)

    explicit ConfigHolder(const std::string& path);
    virtual ~ConfigHolder();

    const CategoryTemplate& categoryTemplate(const std::string& id) const;
    const Section& section(const std::string& id) const;

    const Restrictions& restrictions(const std::string& id) const;
    const Interactivity& interactivity(const std::string& id) const;

    const AttrDefPtr& attribute(const std::string& id) const;
    bool isAttributeDefined(const std::string& id) const;

    const AttrDefPtr& registerSystemAttribute(
        const std::string& id,
        const std::string& defaultValue,
        const StringSet& allowedValues);

    const CategoryGroups& categoryGroups() const { return *categoryGroups_; }

    const OverlayGroups& overlayGroups() const { return *overlayGroups_; }

    const Categories& categories() const { return *categories_; }

    const Countries& countries() const { return *countries_; }

    const TopologyGroups& topologyGroups() const { return *topologyGroups_; }

    const Externals& externals() const { return *externals_; }

    const maps::xml3::Doc& doc() const { return doc_; }

private:
    void init();

    maps::xml3::Doc doc_;

    std::map<std::string, CategoryTemplate> categoryTemplates_;
    std::map<std::string, Section> sections_;
    std::map<std::string, AttrDefPtr> attributes_;
    std::map<std::string, Restrictions> restrictionsById_;
    std::map<std::string, Interactivity> interactivitySettings_;
    std::unique_ptr<CategoryGroups> categoryGroups_;
    std::unique_ptr<OverlayGroups> overlayGroups_;
    std::unique_ptr<Categories> categories_;
    std::unique_ptr<Countries> countries_;
    std::unique_ptr<TopologyGroups> topologyGroups_;
    std::unique_ptr<Externals> externals_;
};

} // maps::wiki::configs::editor
