#pragma once

#include <yandex/maps/wiki/configs/editor/geoobject_templates.h>
#include <yandex/maps/wiki/common/string_utils.h>
#include <maps/libs/xml/include/xml.h>

#include <optional>
#include <unordered_map>
#include <string>
#include <cstdint>

namespace maps::wiki::configs::editor {

using FtTypeId = std::uint16_t;
using DispClass = std::int16_t;
using RubricId = std::uint64_t;


struct Rubric
{
    RubricId id;
    std::optional<FtTypeId> ftType;
    std::optional<DispClass> dispClass;
    std::vector<common::LocalizedString> names;
};

class Rubrics
{
public:
    explicit Rubrics(const maps::xml3::Node& node);

    const std::vector<RubricId>& rubrics(const common::LocalizedString& name) const;
    const Rubric* rubric(RubricId rubricId) const;
    std::optional<DispClass> defaultDispClass(RubricId rubricId) const;
    std::optional<FtTypeId> defaultFtType(RubricId rubricId) const;

private:
    std::unordered_map<RubricId, Rubric> rubricsById_;
    std::map<common::LocalizedString, std::vector<RubricId>> idxRubricsByName_;
};

class Externals
{
public:
    explicit Externals(const maps::xml3::Node& node);

    const Rubrics& rubrics() const
    { return rubrics_; }

    const GeoObjectTemplates& geoObjectTemplates() const
    { return geoObjectTemplates_; }

private:
    Rubrics rubrics_;
    GeoObjectTemplates geoObjectTemplates_;

};

} // namespace maps::wiki::configs::editor
