#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>
#include <maps/libs/xml/include/xml.h>

#include <boost/noncopyable.hpp>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class GeoObjectTemplate;

using TemplateVector = std::vector<GeoObjectTemplate>;
using CategoryToTemplates = std::unordered_map<std::string, TemplateVector>;

class GeoObjectTemplate
{
public:
    explicit GeoObjectTemplate(const maps::xml3::Node& node);

    const std::string& id() const { return id_; }
    const std::string& category() const { return category_; }
    const StringMap& attrValues() const { return attrValues_; }

private:
    std::string id_;
    std::string category_;
    StringMap attrValues_;
};

class GeoObjectTemplates : boost::noncopyable
{
public:
    explicit GeoObjectTemplates(const maps::xml3::Node& node);

    const CategoryToTemplates& allTemplates() const { return templatesByCategory_; }
    const TemplateVector& findTemplates(const std::string& categoryId) const;

private:
    CategoryToTemplates templatesByCategory_;
};

} // editor
} // configs
} // wiki
} // maps
