#pragma once

#include <maps/libs/common/include/pimpl_utils.h>

#include <optional>
#include <string>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class MasterRole
{
public:
    MasterRole(
        std::string roleId,
        std::string categoryId,
        size_t minOccurs,
        std::optional<size_t> maxOccurs);

    const std::string& roleId() const;
    const std::string& categoryId() const;
    size_t minOccurs() const;
    std::optional<size_t> maxOccurs() const;

    bool isRestricted() const;

    COPYABLE_PIMPL_DECLARATIONS(MasterRole)
};

} // editor
} // configs
} // wiki
} // maps
