#pragma once

#include <maps/libs/enum_io/include/enum_io.h>
#include <yandex/maps/wiki/configs/editor/common.h>

#include <maps/libs/xml/include/xml.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

enum class OverlayMode { Required, Forbidden };
DECLARE_ENUM_IO(OverlayMode);

class OverlayGroup
{
public:
    explicit OverlayGroup(const maps::xml3::Node& node);

    const std::string& id() const;
    const std::string& label() const;
    const StringSet& baseCategoryIds() const;
    const StringSet& overlayCategoryIds(OverlayMode mode) const;

    bool isOverlayModeAllowed(const std::string& categoryId, OverlayMode mode) const;

private:
    std::string id_;
    std::string label_;
    StringSet baseCategoryIds_;
    StringSet overlayCategoryIdsRequired_;
    StringSet overlayCategoryIdsForbidden_;
};

class OverlayGroups
{
public:
    explicit OverlayGroups(const maps::xml3::Node& node);

    const StringSet& baseCategoryIdsByGroup(const std::string& groupId) const;
    const StringSet& overlayCategoryIdsByGroup(const std::string& groupId, OverlayMode mode) const;

    std::vector<OverlayGroupPtr> findGroupsByBaseCategoryId(const std::string& categoryId) const;
    std::vector<OverlayGroupPtr> findGroupsByOverlayCategoryId(const std::string& categoryId, OverlayMode mode) const;

    bool isGroupExists(const std::string& groupId) const;
    const OverlayGroupPtr& groupById(const std::string& groupId) const;

    const OverlayGroupByIdMap& allGroups() const;

private:
    OverlayGroupByIdMap overlayGroupsByIds_;
};

} // editor
} // configs
} // wiki
} // maps
