#pragma once

#include <yandex/maps/wiki/configs/editor/size.h>

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <optional>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class Gabarits
{
public:
    explicit Gabarits(const maps::xml3::Node& node);

    std::optional<Size> maxSize() const;
    std::optional<Size> minSize() const;
    std::optional<double> length() const;
    std::optional<double> lengthAccuracy() const;

    COPYABLE_PIMPL_DECLARATIONS(Gabarits)
};

class Restrictions
{
public:
    explicit Restrictions(const maps::xml3::Node& node);

    size_t maxIntersectionWithElement() const;
    size_t maxCrossedElements() const;
    size_t maxVertexes() const;
    size_t maxRichContentLength() const;
    const std::optional<Gabarits>& gabarits() const;

    MOVABLE_PIMPL_DECLARATIONS(Restrictions)
};

} // editor
} // configs
} // wiki
} // maps
