#pragma once

#include <yandex/maps/wiki/configs/editor/slave_role.h>

#include <functional>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

namespace roles {
namespace filters {

typedef std::function<bool(const SlaveRole&)> Filter;

inline bool All(const SlaveRole&)
{
    return true;
}

inline bool IsTable(const SlaveRole& role)
{
    return role.tableRow();
}

inline bool IsNotTable(const SlaveRole& role)
{
    return !role.tableRow();
}

inline bool IsGeom(const SlaveRole& role)
{
    return role.geomPart();
}

inline bool IsNeitherTableNorGeomPart(const SlaveRole& role)
{
    return (!role.tableRow()) && (!role.geomPart());
}

inline bool IsSequentialGeom(const SlaveRole& role)
{
    return role.geomPart() && role.sequential();
}

} // filters
} // roles

} // editor
} // configs
} // wiki
} // maps
