#pragma once

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class Size
{
public:
    Size(double width, double height);
    explicit Size(const maps::xml3::Node& node);

    double width() const;
    double height() const;

    /**
    * Check that this size is greater
    * in either orientation
    */
    bool greater(const Size& other) const;

    /**
    * Check that this size is less
    * in either orientation
    */
    bool less(const Size& other) const;

    COPYABLE_PIMPL_DECLARATIONS(Size)
};

} // editor
} // configs
} // wiki
} // maps
