#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>

#include <maps/libs/xml/include/xml.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <optional>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class SlaveRole
{
public:
    explicit SlaveRole(const maps::xml3::Node& node);

    const std::string& roleId() const;
    const std::string& categoryId() const;

    //! min number of slave occurrences of this role
    size_t minOccurs() const;

    //! max number of slave occurrences of this role
    size_t maxOccurs() const;

    //! min number of master occurrences of this role
    size_t masterMinOccurs() const;

    //! max number of master occurrences of this role
    std::optional<size_t> masterMaxOccurs() const;

    //! Is it possible to remove object of this role from container
    bool allowDelete() const;

    //! Is it possible to replace object of this role in container(merge)
    bool allowReplace() const;

    //! Should we keep all parts of object in container, or adjacent ones
    bool keepAll() const;

    //! Should object of this role inherit label from container
    bool inheritLabels() const;

    //! Refernced object is a row in the table
    bool tableRow() const;

    //! Slaves should be ordered by seq-num
    bool sequential() const;

    //! Slaves create geometry of object
    bool geomPart() const;

    bool allowSelfReference() const;

    bool deleteUnused() const;

    bool limitSlaveEditNotes() const;

    bool nonBlocking() const;

    std::optional<size_t> slavesPerRoleOutputLimit() const;

    //! For UniqueList
    operator std::string() const;

    static StringVec nonSyncViewRoles();
    static bool isSyncViewRole(const std::string& role);

    MOVABLE_PIMPL_DECLARATIONS(SlaveRole)
};

} // editor
} // configs
} // wiki
} // maps
