#pragma once

#include <yandex/maps/wiki/configs/editor/common.h>
#include <yandex/maps/wiki/configs/editor/magic_strings.h>
#include <yandex/maps/wiki/configs/editor/zoom_interval.h>

#include <maps/libs/xml/include/xml.h>

#include <boost/noncopyable.hpp>

#include <unordered_map>
#include <vector>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

class TopologyGroup
{
public:
    class Interactivity
    {
    public:
        explicit Interactivity(const xml3::Node& node);

        ZoomInterval highlightingZoom() const { return highlightingZoom_; }
        double junctionAccuracy() const { return junctionAccuracy_; }
        double vertexAccuracy() const { return vertexAccuracy_; }

    private:
        ZoomInterval highlightingZoom_;
        double junctionAccuracy_;
        double vertexAccuracy_;
    };

    explicit TopologyGroup(const xml3::Node& node);

    bool isInGroup(const std::string categoryId) const;
    const StringSet& linearElementsCategories() const { return linearElementsCategories_; }
    const std::string& junctionsCategory() const { return junctionsCategory_; }

    static const std::string& startJunctionRole() { return ROLE_START; }
    static const std::string& endJunctionRole()   { return ROLE_END;   }

    double tolerance() const { return tolerance_; }
    double maxJunctionGravity() const { return maxJunctionGravity_; }
    double maxVertexGravity() const { return maxVertexGravity_; }
    double maxGroupJunctionGravity() const { return maxGroupJunctionGravity_; }
    double maxGroupJunctionSnapVertexGravity() const {
        return maxGroupJunctionSnapVertexGravity_;
    }
    bool allowClosedEdge() const { return allowClosedEdge_; }
    bool allowMergeOfOverlappedEdges() const { return allowMergeOfOverlappedEdges_; }

    double junctionGravity(TZoom) const;
    double vertexGravity(TZoom) const;

    const Interactivity& interactivity() const { return interactivity_; }

private:
    std::string junctionsCategory_;
    StringSet linearElementsCategories_;
    double tolerance_;
    double maxJunctionGravity_;
    double maxVertexGravity_;
    double maxGroupJunctionGravity_;
    double maxGroupJunctionSnapVertexGravity_;
    bool allowClosedEdge_;
    bool allowMergeOfOverlappedEdges_;
    Interactivity interactivity_;
};

class TopologyGroups : boost::noncopyable
{
public:
    explicit TopologyGroups(const xml3::Node& node);

    const TopologyGroup* findGroup(const std::string& categoryId) const;

    std::vector<TopologyGroup>::const_iterator begin() const { return groups_.begin(); }
    std::vector<TopologyGroup>::const_iterator end() const { return groups_.end(); }

private:
    std::vector<TopologyGroup> groups_;
    std::unordered_map<std::string, size_t> indexGroupsByCat_;
};

} // namespace editor
} // namespace configs
} // namespace wiki
} // namespace maps
