#pragma once

#include <maps/libs/xml/include/xml.h>

namespace maps {
namespace wiki {
namespace configs {
namespace editor {

using TZoom = unsigned short;

class ZoomInterval
{
public:
    ZoomInterval(TZoom zmin, TZoom zmax);
    explicit ZoomInterval(const maps::xml3::Node& node);

    TZoom zmin() const { return zmin_; }
    TZoom zmax() const { return zmax_; }

    bool check(TZoom zoom) const
    {
        return (zoom >= zmin_) && (zoom <= zmax_);
    }

private:
    TZoom zmin_;
    TZoom zmax_;
};

} // editor
} // configs
} // wiki
} // maps
